﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Core.GIODO" %>
<%@ Import Namespace="Soneta.Core.UI.GIODO" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Rejestr czynności przetwarzania</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

    <script runat="server">

        void OnContextLoad(Object sender, EventArgs args)
        {
            var title = "Zgoda na przetwarzanie danych|";
            GIODOOświadczenie oswiadczenie = (GIODOOświadczenie)dc[typeof(GIODOOświadczenie)];
            title += "</STRONG>Dokument:<STRONG> " + oswiadczenie.Numer.NumerPelny + ",|";
            title += "</STRONG>Data wystawienia:<STRONG> " + oswiadczenie.Data.ToString("dd.MM.yyyy");
            ReportHeader.Title = title;

            Nazwa.EditValue = oswiadczenie.Host.Nazwa;
            var firma = CoreModule.GetInstance(oswiadczenie).Config.Firma;
            var tresc = oswiadczenie.Definicja.Tresc.ToString()
                                        .Replace("{Session.Core.Config.Firma.Pieczątka.Nazwa}", firma.Pieczątka.Nazwa)
                                        .Replace("{Session.Core.Config.Firma.AdresSiedziby.Linia1}", firma.AdresSiedziby.Linia1)
                                        .Replace("{Session.Core.Config.Firma.AdresSiedziby.Linia2}", firma.AdresSiedziby.Linia2);
            Tresc.EditValue = tresc;
            stPodpis.Caption = "<font size=1> </font><font size=2>"+""+"</font><br><br><br><font size=1>..................................................<br>Podpis udzielającego zgody</font>";
        }

    </script>
</head>
<body>
    <form method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
        <eb:ReportHeader id="ReportHeader" runat="server" title="Zgoda na przetwarzanie danych"></eb:ReportHeader>

        <table id="Table1" cellspacing="0" cellpadding="1" width="100%" border="0" style="font-family: Tahoma, Arial; margin-top: 20px; margin-bottom: 30px; ">
            <tr>
                <td style="text-align: center;">
                    <br />
                    <b>Zgoda na przetwarzanie danych osobowych</b>
                </td>
            </tr>
            <tr>
                <td style="">
                    <br />
                    Udzielający zgody:
                    <ea:datalabel runat="server" id="Nazwa" encodehtml="true" ></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td style="text-align: justify;">
                    <br />
                    <ea:datalabel runat="server" id="Tresc" Bold="False" encodehtml="true" ></ea:datalabel>
                </td>
            </tr>
        </table>

        <eb:ReportFooter id="ReportFooter" runat="server">
            <subtitles>
                <eb:FooterSubtitle runat="server" Caption="" SubtitleType="Empty" Width="50"></eb:FooterSubtitle>
                <eb:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></eb:FooterSubtitle>
          </subtitles>
        </eb:ReportFooter>
    </form>
</body>
</html>
